
$(document).ready(function() {
    let myChart; // Variable to store the chart instance

    // Function to fetch data from PHP based on selected interval
    function fetchData(interval) {
        $.ajax({
            url: 'fetch_pickup_data',
            method: 'GET',
            data: {
                interval: interval
            },
            success: function(response) {
                renderChart(response, interval);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching data:', error);
            }
        });
    }

    // Render initial chart on page load (default: daily)
    fetchData('daily');

    // Event listener for select interval dropdown change
    $('#selectInterval').change(function() {
        const selectedInterval = $(this).val();
        fetchData(selectedInterval);
    });

    // Function to render Chart
    function renderChart(data, interval) {
        if (myChart) {
            // Destroy existing chart instance if it exists
            myChart.destroy();
        }

        const ctx = document.getElementById('pickupChart').getContext('2d');
        myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: [interval], // Using the interval as the label for clarity
                datasets: [{
                    label: 'Pickup History',
                    data: data,
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1,
                    fill: false
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    }
});

$(document).ready(function() {
    let deliveryChart; // Variable to store the chart instance

    // Function to fetch delivery data from PHP based on selected interval
    function fetchDeliveryData(interval) {
        $.ajax({
            url: 'fetch_delivery_data',
            method: 'GET',
            data: {
                interval: interval
            },
            success: function(response) {
                renderDeliveryChart(response, interval);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching delivery data:', error);
            }
        });
    }

    // Event listener for select interval dropdown change (for delivery chart)
    $('#deliverySelectInterval').change(function() {
        const selectedInterval = $(this).val();
        fetchDeliveryData(selectedInterval);
    });

    // Function to render Delivery Chart
    function renderDeliveryChart(data, interval) {
        if (deliveryChart) {
            // Destroy existing chart instance if it exists
            deliveryChart.destroy();
        }

        const ctx = document.getElementById('deliveryChart').getContext('2d');
        deliveryChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: [interval], // Using the interval as the label for clarity
                datasets: [{
                    label: 'Delivery History',
                    data: data,
                    borderColor: 'rgba(255, 99, 132, 1)', // Adjust color as needed
                    borderWidth: 1,
                    fill: false
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    }

    // Initial rendering of the delivery chart on page load
    fetchDeliveryData('daily');
});
$(document).ready(function() {
  $('#exampleModal').modal({
    show: false // Ensure modal is hidden by default
  });
});

  $(document).ready(function() {
    $('.viewItem').on('click',function() {
      const orderId = $(this).attr("name");
      const itemId = $(this).attr("title");

      $.ajax({
        url: 'get_order',
        method: 'GET',
        data: {
          orderId: orderId,
          itemId: itemId
        },
        dataType: 'json',
        success: function(data) {
          const card = `
            <div class="card">
              <img src="../dist/img/${data.imageUrl}" class="card-img-top" alt="Item Image">
              <div class="card-body">
                <h5 class="card-title">${data.title}</h5>
                <p>style: ${data.style} variation: ${data.variation}</p>
                <p class="card-text">Storename: ${data.storename}</p>
                <p class="card-text">Quantity: ${data.quantity}</p>
                <p class="alert alert-warning">kindly check the item for any damages and quantity before taking it to the warehouse. Thank you!</p>
              </div>
            </div>
          `;

          $('.modal-body').html(card);
          $('#exampleModal').modal('show');
        },
        error: function(xhr, status, error) {
          console.error('Error:', error);
        }
      });
    });
  });