<?php
include_once('includes/dbconn.php');

// Function to fetch delivery data based on the selected interval and date range
function fetchDeliveryData($connection, $interval) {
    $data = array(); 

    // Logic to fetch data based on the selected interval and date range
    // Adjust SQL queries based on your database structure
    if ($interval === 'daily') {
        $sql = SELECTDELIVERYORDER." and delivery_status='warehouse' and date_time_assigned_delivery >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
    } elseif ($interval === 'monthly') {
        $sql = SELECTDELIVERYORDER." and delivery_status='warehouse' and date_time_assigned_delivery >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
    } elseif ($interval === 'yearly') {
        $sql = SELECTDELIVERYORDER." and delivery_status='warehouse' and date_time_assigned_delivery >= DATE_SUB(NOW(), INTERVAL 1 YEAR)";
    }

    $result = $connection->query($sql);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = intval($row['count']); // Store count as an integer in the data array
        }
    }

    return $data;
}

// Check if interval parameter is set in the GET request
if (isset($_GET['interval'])) {
    $selectedInterval = $_GET['interval'];

    // Fetch delivery data based on the selected interval and date range
    $deliveryData = fetchDeliveryData($connection, $selectedInterval);

    // Return delivery data as JSON
    header('Content-Type: application/json');
    echo json_encode($deliveryData);
} else {
    echo "Invalid request";
}
?>
