<?php
/**
 * An example of an autoload register for manual installation
 * 
 * After registering this autoload function with SPL, the following line
 * would cause the function to attempt to load the \Square\Baz class
 * from /path/to/project/src/Baz.php:
 * 
 *      new \Square\Baz;
 *      
 * @param string $class The fully-qualified class name.
 * @return void
 */
 spl_autoload_register(function ($class) {
    $prefixToLocation = [
        "Square\\" => "/square-php-sdk/src/",
        "apimatic\\jsonmapper\\" => "/jsonmapper/src/",
        "Unirest\\" => "/unirest-php/src/",
        "Core\\" => "/core-lib-php/src/",
        "CoreInterfaces\\" => "/core-interfaces-php/src/",
    ];

    $matchingPrefix = null;
    foreach ($prefixToLocation as $prefix => $location) {
        $len = strlen($prefix);
        if (strncmp($prefix, $class, $len) !== 0) {
            continue;
        } else {
            $matchingPrefix = $prefix;
            break;
        }
    }

    if (!$matchingPrefix) {
        echo("No matching prefix found for class: $class\n");
        return;
    }

    $base_dir = __DIR__ . $prefixToLocation[$matchingPrefix];
    $relative_class = substr($class, strlen($matchingPrefix));
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    echo("Trying to load file: " . $file . "\n");  // Debugging line

    if (file_exists($file)) {
        require $file;
        echo("Loaded file: " . $file . "\n");  // Debugging line
    } else {
        echo("Error loading: " . $file . "\n");
    }
});
// Main script logic
use Square\SquareClient;
use Square\LocationsApi;
use Square\Exceptions\ApiException;
use Square\Http\ApiResponse;
use Square\Models\ListLocationsResponse;
use Square\Environment;
use Square\Models\Money;
use Square\Models\CreatePaymentRequest;
use Square\Models\CreatePayment;

try {
    $client = new SquareClient([
        'accessToken' => 'YOUR_ACCESS_TOKEN',
        'environment' => Environment::SANDBOX,
    ]);

    $locationsApi = $client->getLocationsApi();
    $apiResponse = $locationsApi->listLocations();

    if ($apiResponse->isSuccess()) {
        $listLocationsResponse = $apiResponse->getResult();
        print_r($listLocationsResponse);
    } else {
        $errors = $apiResponse->getErrors();
        print_r($errors);
    }
} catch (ApiException $e) {
    echo 'Caught exception: ', $e->getMessage(), "\n";
}
