<?php
// Allow cross-origin requests (if needed)
// header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
include('includes/dbconn.php');
if ($_SERVER['REQUEST_METHOD'] === 'POST') { 
    function updateinformation($connection, $web_name, $web_description, $website_about_titlle, $web_about, $whatsapp, $more_d, $more_title, $more_header) {
        $stmt = $connection->prepare("UPDATE `website_settings` SET `website_name`=?, `website_description`=?, `website_about_titlle`=?, `website_about`=?, `whatsapp_number`=?, `more_title`=?, `more_header`=?, `more_d`=?");
        $stmt->bind_param("ssssssss", $web_name, $web_description, $website_about_titlle, $web_about, $whatsapp, $more_title, $more_header, $more_d);
        $stmt->execute();
        $stmt->close();
    }

    function updatepayment($connection, $pk, $sk, $ps, $pl, $url) {
        $stmt = $connection->prepare("UPDATE `pamentsettings` SET `gateway`='stripe', `Processkey`=?, `Authorizationkey`=?, `contractCode`=?, `status`=?, `url`=?");
        $stmt->bind_param("sssss", $pk, $sk, $pl, $ps, $url);
        $stmt->execute();
        $stmt->close();
    }

    function updatemailer($connection, $hn, $hu, $hp, $hpp) {
        $stmt = $connection->prepare("UPDATE `mailer` SET `hostname`=?, `Username`=?, `password`=?, `port`=?");
        $stmt->bind_param("ssss", $hn, $hu, $hp, $hpp);
        $stmt->execute();
        $stmt->close();
        
        $_SESSION['mailerhostname'] = $hn;
        $_SESSION['mailerusername'] = $hu;
        $_SESSION['mailerpass'] = $hp;
        $_SESSION['mailerport'] = $hpp;
    }
function updateFile($filename, $content) {
    // Try to open the file for writing ('w' mode)
    $file = fopen($filename, 'w');

    // Check if the file was opened successfully
    if ($file) {
        // Write the content to the file
        fwrite($file, $content);
        
        // Close the file to free up resources
        fclose($file);
    }
}


    function updateheading($heading) {
        $filename = '../app/include_in_heading.php';
        updateFile($filename, $heading);
    }

    function updatefooter($footer) {
        $filename = '../app/include_in_footer.php';
        updateFile($filename, $footer);
    }

    // Validate and process the form data
    if (isset($_POST['website_name'], $_POST['website_description'], $_POST['website_about'], $_POST['whatsapp_number'], $_POST['website_about_titlle'])) {
        if (!empty($_POST['website_name']) && !empty($_POST['website_description']) && !empty($_POST['website_about']) && !empty($_POST['whatsapp_number']) && !empty($_POST['website_about_titlle'])) {
            $web_name = $connection->real_escape_string($_POST['website_name']);
            $web_description = $_POST['website_description'];
            $web_about = $_POST['website_about'];
            $more_title = $_POST['more_title'];
            $more_header = $_POST['more_header'];
            $more_d = $_POST['more_d'];
            $whatsapp = $connection->real_escape_string($_POST['whatsapp_number']);
            $website_about_titlle = $connection->real_escape_string($_POST['website_about_titlle']);

            updateinformation($connection, $web_name, $web_description, $website_about_titlle, $web_about, $whatsapp, $more_d, $more_title, $more_header);
        } else {
            $response['message'] = "Some form fields are missing in website information section";
            echo json_encode($response);
            exit;
        }
    }

    // Payment section
    if (isset($_POST['public_key'], $_POST['private_key'], $_POST['payment_status'], $_POST['payment_location'])) {
        if (!empty($_POST['public_key']) && !empty($_POST['private_key']) && !empty($_POST['payment_status']) && !empty($_POST['payment_location'])) {
            $pk = $connection->real_escape_string($_POST['public_key']);
            $sk = $connection->real_escape_string($_POST['private_key']);
            $ps = $connection->real_escape_string($_POST['payment_status']);
            $pl = $connection->real_escape_string($_POST['payment_location']);
            $url = $_POST['pay_url'];

            updatepayment($connection, $pk, $sk, $ps, $pl, $url);
        } else {
            $response['message'] = "Some form fields are missing in payment section";
            echo json_encode($response);
            exit;
        }
    }

    // Mailer section
    if (isset($_POST['hostname'], $_POST['hostusername'], $_POST['password'], $_POST['port'])) {
        if (!empty($_POST['hostname']) && !empty($_POST['hostusername']) && !empty($_POST['password']) && !empty($_POST['port'])) {
            $hn = $connection->real_escape_string($_POST['hostname']);
            $hu = $connection->real_escape_string($_POST['hostusername']);
            $hp = $connection->real_escape_string($_POST['password']);
            $hpp = $connection->real_escape_string($_POST['port']);

            updatemailer($connection, $hn, $hu, $hp, $hpp);
        } else {
            $response['message'] = "Some form fields are missing in mailer section";
            echo json_encode($response);
            exit;
        }
    }

    // Footer section
    if (isset($_POST['footer']) && !empty($_POST['footer'])) {
        $footer = $_POST['footer'];
        if (updatefooter($connection, $footer)) {
            $response = [
                "status" => "success",
                "message" => "Website has been updated successfully"
            ];
        } else {
            $response['message'] = "Failed to update footer content";
        }
    }
$response = [
                "status" => "success",
                "message" => "Website has been updated successfully".$_POST['website_name']
            ];
    echo json_encode($response);
    exit;

} else {
    // Handle the case where the form was not submitted via POST
    $response = [
        "status" => "error",
        "message" => "Invalid request method"
    ];
    echo json_encode($response);
}
?>