<?php
    include 'app/dbconn.php';
// Get the form data
// Get the form data
$firstname = isset($_POST['firstname']) ? $_POST['firstname'] : '';
$lastname = isset($_POST['lastname']) ? $_POST['lastname'] : '';
$companyname = isset($_POST['companyname']) ? $_POST['companyname'] : '';
$country_region = isset($_POST['country_region']) ? $_POST['country_region'] : '';
$state = isset($_POST['state']) ? $_POST['state'] : '';
$Street_address = isset($_POST['Street_address']) ? $_POST['Street_address'] : '';
$Apartment = isset($_POST['Apartment']) ? $_POST['Apartment'] : '';
$Postcode_ZIP = isset($_POST['Postcode_ZIP']) ? $_POST['Postcode_ZIP'] : '';
$billing_city = isset($_POST['billing_city']) ? $_POST['billing_city'] : '';
$billing_phone = isset($_POST['billing_phone']) ? $_POST['billing_phone'] : '';
$billing_mail = isset($_POST['billing_mail']) ? $_POST['billing_mail'] : '';

// Check for empty strings
if (empty($firstname) || empty($lastname) || empty($country_region) || empty($Street_address) || empty($billing_city) || empty($billing_phone) || empty($billing_mail)) {
    echo "Please fill out all required fields.";
    exit;
}

// Check if the user already exists in the database
$stmt = $connection->prepare("SELECT COUNT(*) FROM billing_address WHERE billing_mail = ?");
$stmt->bind_param("s", $billing_mail);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$stmt->close();

// If the user already exists, update the existing entry
if ($row['COUNT(*)'] > 0) {
    $stmt = $connection->prepare("UPDATE billing_address SET firstname = ?, lastname = ?, companyname = ?, country_region = ?, state = ?, Street_address = ?, Apartment = ?, Postcode_ZIP = ?, billing_city = ?, billing_phone = ? WHERE billing_mail = ?");
    $stmt->bind_param("ssssssssss", $firstname, $lastname, $companyname, $country_region, $state, $Street_address, $Apartment, $Postcode_ZIP, $billing_city, $billing_phone, $billing_mail);
    $stmt->execute();
    $stmt->close();

    // Echo a success message
    echo "Your billing address has been updated.";
}
// If the user does not exist, insert a new entry
else {
    $stmt = $connection->prepare("INSERT INTO billing_address (firstname, lastname, companyname, country_region, Street_address, Apartment, Postcode_ZIP, billing_city, billing_phone, billing_mail) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssss", $firstname, $lastname, $companyname, $country_region,$state, $Street_address, $Apartment, $Postcode_ZIP, $billing_city, $billing_phone, $billing_mail);
    $stmt->execute();
    $stmt->close();

    // Echo a success message
    echo "Your billing address has been added.";
}
?>