<?php
include_once('includes/dbconn.php');
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['orderId']) && isset($_POST['itemId']) && isset($_POST['pickupCode']) && isset($_POST['Buyer'])) {
    $orderId = $_POST['orderId'];
    $itemId = $_POST['itemId'];
    $pickupCode = $_POST['pickupCode'];
    $buyer=$_POST['Buyer'];
    if (!ctype_digit($orderId) || !ctype_digit($itemId)) {
        echo "Invalid input format";
        exit;
    }$sql = "SELECT * FROM pickup_assigned_order WHERE item_order_id = ? AND item_special_id = ? AND pickup_code = ? AND session=?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("iiss", $orderId, $itemId, $pickupCode,$buyer);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
       
        $updateSql = "UPDATE pickup_assigned_order SET warehouse_drop_status = 'picked', pickup_code = NULL, date_picked_up=now() WHERE item_order_id = ? AND item_special_id = ? AND pickup_code = ? AND session=?";
        $updateStmt = $connection->prepare($updateSql);
        $updateStmt->bind_param("iiss", $orderId, $itemId, $pickupCode,$buyer);
        $updateStmt->execute();

        if ($updateStmt->affected_rows > 0) {
            echo "Order picked successfully, remember to take it"; 
        } else {
            echo "Failed to update status";     }

        $updateStmt->close();
    } else {
        echo "Incorrect pickup code";     }

    $stmt->close();
    $connection->close();
} else {
    echo "Invalid request";
}
?>