<?php
include_once('includes/dbconn.php');

// Function to fetch pickup data based on the selected interval and date range
function fetchPickupData($connection, $interval) {
    $data = array();

    // Logic to fetch data based on the selected interval and date range
    if ($interval === 'daily') {
        $sql = SELECTPICKUPORDER." and warehouse_drop_status='warehouse' and date_time_assigned_pick >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
    } elseif ($interval === 'monthly') {
        $sql = SELECTPICKUPORDER." and warehouse_drop_status='warehouse' and date_time_assigned_pick >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
    } elseif ($interval === 'yearly') {
        $sql = SELECTPICKUPORDER." and warehouse_drop_status='warehouse' and date_time_assigned_pick >= DATE_SUB(NOW(), INTERVAL 1 YEAR)";
    }

    $result = $connection->query($sql);

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row; // Store fetched rows in the data array
        }
    }

    return $data;
}

// Check if interval parameter is set in the GET request
if (isset($_GET['interval'])) {
    $selectedInterval = $_GET['interval'];

    // Fetch pickup data based on the selected interval and date range
    $pickupData = fetchPickupData($connection, $selectedInterval);

    // Return pickup data as JSON
    header('Content-Type: application/json');
    echo json_encode($pickupData);
} else {
    echo "Invalid request";
}
?>
